/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.CustomOptionCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.OptionContainer;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public class UnsetCustomOptionCommandTest
extends CustomOptionCommandTest {
    @Test
    public void testCustomOptionTable() throws Exception {
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        this.setup("commandFiles", "addCustomOptions.cmd");
        String[] commands = new String[]{"unset-custom-option myCustomOption1", "unset-custom-option My\"Custom\"Option3"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String[][] expectedOptions = new String[][]{{"myCustomOption2", "myValue2"}, {"MyCustomOption3", "myValue3"}, {"my.custom.option", "myValue1"}};
        Vdb vdb = this.getVDB("myVDB1", wkspMgr);
        Assert.assertNotNull((Object)vdb);
        Model[] models = vdb.getModels(this.getTransaction(), new String[]{"myModel1"});
        Assert.assertEquals((long)1L, (long)models.length);
        Table[] tables = models[0].getTables(this.getTransaction(), new String[]{"myTable1"});
        Assert.assertEquals((long)1L, (long)tables.length);
        this.assertCustomOptions((OptionContainer)tables[0], expectedOptions);
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myCustomOption1");
        candidates.add("myCustomOption2");
        candidates.add("my.custom.option");
        this.setup("commandFiles", "addCustomOptions.cmd");
        this.assertTabCompletion("unset-custom-option my", candidates);
        candidates.add("MyCustomOption3");
        candidates.add("My\"Custom\"Option3");
        this.assertTabCompletion("unset-custom-option ", candidates);
    }
}

