/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.column;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetColumnPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-column myColumn", "cd myColumn", "set-property NAMEINSOURCE myNameInSource", "unset-property NAMEINSOURCE"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)vdbs.length, (long)1L);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((float)1.0f, (float)models.length, (float)1.0f);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Table[] tables = models[0].getTables(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)tables.length);
        Assert.assertEquals((Object)"myTable", (Object)tables[0].getName(this.getTransaction()));
        Column[] columns = tables[0].getColumns(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)"myColumn", (Object)columns[0].getName(this.getTransaction()));
        String nameInSource = columns[0].getNameInSource(this.getTransaction());
        Assert.assertNull((Object)nameInSource);
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addColumns.cmd");
        String[] commands = new String[]{"cd myColumn1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("NAMEINSOURCE");
        candidates.add("NATIVE_TYPE");
        this.assertTabCompletion("unset-property na", candidates);
        this.assertTabCompletion("unset-property NA", candidates);
    }
}

