/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.connection;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class SetConnectionPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testSetProperty1() throws Exception {
        String[] commands = new String[]{"create-connection testSource", "cd testSource", "set-property jndiName java:/testSource"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] sources = wkspMgr.findConnections(this.getTransaction());
        Assert.assertEquals((long)1L, (long)sources.length);
        Assert.assertEquals((Object)"testSource", (Object)sources[0].getName(this.getTransaction()));
        Assert.assertEquals((Object)"java:/testSource", (Object)sources[0].getJndiName(this.getTransaction()));
    }

    @Test
    public void shouldSetDescription() throws Exception {
        String description = "blah";
        String[] commands = new String[]{"create-connection testSource", "cd testSource", "set-property description blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] sources = wkspMgr.findConnections(this.getTransaction());
        Assert.assertThat((Object)sources.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)sources[0].getDescription(this.getTransaction()), (Matcher)Is.is((Object)"blah"));
    }

    @Test
    public void shouldSetExternalLocation() throws Exception {
        String extLoc = "/Users/sledge/blah";
        String[] commands = new String[]{"create-connection testSource", "cd testSource", "set-property externalLocation /Users/sledge/blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] connections = wkspMgr.findConnections(this.getTransaction());
        Assert.assertThat((Object)connections.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)connections[0].getExternalLocation(this.getTransaction()), (Matcher)Is.is((Object)"/Users/sledge/blah"));
    }
}

