/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.connection;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetConnectionPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-connection testSource", "cd testSource", "set-property jndiName java:/testSource", "unset-property jndiName"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] connections = wkspMgr.findConnections(this.getTransaction());
        Assert.assertEquals((long)1L, (long)connections.length);
        Assert.assertEquals((Object)"testSource", (Object)connections[0].getName(this.getTransaction()));
        Assert.assertEquals(null, (Object)connections[0].getJndiName(this.getTransaction()));
    }

    @Test
    public void shouldUnsetDescription() throws Exception {
        String[] commands = new String[]{"create-connection testSource", "cd testSource", "set-property description blah", "unset-property description"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] connections = wkspMgr.findConnections(this.getTransaction());
        Assert.assertThat((Object)connections.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)connections[0].getDescription(this.getTransaction()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldUnsetExternalLocation() throws Exception {
        String[] commands = new String[]{"create-connection testSource", "cd testSource", "set-property externalLocation /Users/sledge/blah", "unset-property externalLocation"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] connections = wkspMgr.findConnections(this.getTransaction());
        Assert.assertThat((Object)connections.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)connections[0].getExternalLocation(this.getTransaction()), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }
}

