/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public class AddMappedRoleCommandTest
extends AbstractCommandTest {
    @Test
    public void testSetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "add-mapped-role myMappedRole"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        String[] mappedRoles = dataRoles[0].getMappedRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)mappedRoles.length);
        Assert.assertEquals((Object)"myMappedRole", (Object)mappedRoles[0]);
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateMappedRoleWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-mapped-role myMappedRole";
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "add-mapped-role myMappedRole", "add-mapped-role myMappedRole"};
        this.execute(commands);
    }
}

