/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteMappedRoleCommandTest
extends AbstractCommandTest {
    @Test
    public void testSetProperty1() throws Exception {
        String[] commands = new String[]{"workspace", "create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-mapped-role myMappedRole1", "add-mapped-role myMappedRole2", "delete-mapped-role myMappedRole1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        String[] mappedRoles = dataRoles[0].getMappedRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)mappedRoles.length);
        Assert.assertEquals((Object)"myMappedRole2", (Object)mappedRoles[0]);
    }

    @Test
    public void testTabCompleter() throws Exception {
        this.setup("commandFiles", "addMappedRoles.cmd");
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myMappedRole1");
        candidates.add("myMappedRole2");
        this.assertTabCompletion("delete-mapped-role m", candidates);
        candidates.add("MyMappedRole3");
        this.assertTabCompletion("delete-mapped-role ", candidates);
    }

    @Test(expected=AssertionError.class)
    public void shouldFailDeletingMappedRoleThatDoesNotExist() throws Exception {
        String[] commands = new String[]{"workspace", "create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-mapped-role myMappedRole1", "delete-mapped-role bogusMappedRole"};
        this.execute(commands);
    }
}

