/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowMappedRolesCommandTest
extends AbstractCommandTest {
    private static final String ROLE_1 = "my_role";
    private static final String ROLE_2 = "your_role";
    private static final String ROLE_3 = "role_3";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "add-mapped-role my_role", "add-mapped-role your_role", "add-mapped-role role_3"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shoudAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-mapped-roles  *r_* my_role"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(ROLE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shoudDisplayMappedRoles() throws Exception {
        String[] commands = new String[]{"show-mapped-roles"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(ROLE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shoudDisplayMappedRolesThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-mapped-roles *3*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(ROLE_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shoudNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-mapped-roles *blah*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(ROLE_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(ROLE_3), (Matcher)Is.is((Object)false));
    }
}

