/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowPermissionsCommandTest
extends AbstractCommandTest {
    private static final String PERMISSION_1 = "my_permission";
    private static final String PERMISSION_2 = "your_permission";
    private static final String PERMISSION_3 = "messi";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission my_permission", "add-permission your_permission", "add-permission messi"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shoudAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-permissions mes* your_permission"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shoudDisplayPermissions() throws Exception {
        String[] commands = new String[]{"show-permissions"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shoudDisplayPermissionsThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-permissions my_*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shoudNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-permissions blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PERMISSION_3), (Matcher)Is.is((Object)false));
    }
}

