/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetDataRolePropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "set-property description myDescription", "unset-property description"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        Assert.assertEquals((Object)"myDataRole", (Object)dataRoles[0].getName(this.getTransaction()));
        Assert.assertEquals(null, (Object)dataRoles[0].getDescription(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addDataRoles.cmd");
        String[] commands = new String[]{"cd myDatarole1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertTabCompletion("unset-property ANN", candidates);
        candidates.add("anyAuthenticated");
        this.assertTabCompletion("unset-property AN", candidates);
        this.assertTabCompletion("unset-property An", candidates);
    }
}

