/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.foreignkey;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.ForeignKey;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteReferenceColumnCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model refModel", "cd refModel", "add-table refTable", "cd refTable", "add-column refCol1", "add-column refCol2", "cd ../..", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-foreign-key myForeignKey /workspace/myVdb/refModel/refTable", "cd myForeignKey", "add-ref-column /workspace/myVdb/refModel/refTable/refCol1", "add-ref-column /workspace/myVdb/refModel/refTable/refCol2", "commit", "delete-ref-column /workspace/myVdb/refModel/refTable/refCol1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)2L, (long)models.length);
        Model modelWithFk = models[0];
        if (!modelWithFk.getName(this.getTransaction()).equals("myModel")) {
            modelWithFk = models[1];
        }
        Assert.assertEquals((Object)"myModel", (Object)modelWithFk.getName(this.getTransaction()));
        Table[] tables = modelWithFk.getTables(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)tables.length);
        Assert.assertEquals((Object)"myTable", (Object)tables[0].getName(this.getTransaction()));
        ForeignKey[] fks = tables[0].getForeignKeys(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)fks.length);
        Assert.assertEquals((Object)"myForeignKey", (Object)fks[0].getName(this.getTransaction()));
        Column[] refCols = fks[0].getReferencesColumns(this.getTransaction());
        Assert.assertEquals((long)1L, (long)refCols.length);
        Assert.assertEquals((Object)"refCol2", (Object)refCols[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addRefColumns.cmd");
        candidates.add("/workspace/user/myVDB1/myModel1/myTable2/myColumn1");
        candidates.add("/workspace/user/myVDB1/myModel1/myTable2/myColumn2");
        this.assertTabCompletion("delete-ref-column /workspace/user/myVDB1/myModel1/myTable2/myC", candidates);
        candidates.add("/workspace/user/myVDB1/myModel1/myTable2/MyColumn3");
        this.assertTabCompletion("delete-ref-column ", candidates);
    }
}

