/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.mask;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetMaskPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "add-mask myMask", "cd myMask", "set-property order myOrder", "unset-property order"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)permissions.length);
        Assert.assertEquals((Object)"myPermission", (Object)permissions[0].getName(this.getTransaction()));
        Mask[] masks = permissions[0].getMasks(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)masks.length);
        Assert.assertEquals((Object)"myMask", (Object)masks[0].getName(this.getTransaction()));
        Assert.assertEquals(null, (Object)masks[0].getOrder(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addMasks.cmd");
        String[] commands = new String[]{"cd myMask1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertTabCompletion("unset-property OODE", candidates);
        candidates.add("order");
        this.assertTabCompletion("unset-property or", candidates);
        this.assertTabCompletion("unset-property OR", candidates);
    }
}

