/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.StoredProcedure;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class AddStoredProcedureCommandTest
extends AbstractCommandTest {
    @Test
    public void testAdd1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-stored-procedure myStoredProcedure"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Procedure[] procs = models[0].getProcedures(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)procs.length);
        Assert.assertEquals((Object)true, (Object)(procs[0] instanceof StoredProcedure));
        Assert.assertEquals((Object)"myStoredProcedure", (Object)procs[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateStoredProcedureWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-stored-procedure myStoredProcedure";
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-stored-procedure myStoredProcedure", "add-stored-procedure myStoredProcedure"};
        this.execute(commands);
    }
}

