/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.View;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class AddViewCommandTest
extends AbstractCommandTest {
    @Test
    public void testAdd1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-view myView"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        View[] views = models[0].getViews(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)views.length);
        Assert.assertEquals((Object)"myView", (Object)views[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateViewWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-view myView";
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-view myView", "add-view myView"};
        this.execute(commands);
    }
}

