/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.StoredProcedure;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteStoredProcedureCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-stored-procedure myStoredProcedure1", "add-stored-procedure myStoredProcedure2", "delete-stored-procedure myStoredProcedure1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Procedure[] procs = models[0].getProcedures(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)procs.length);
        Assert.assertEquals((Object)true, (Object)(procs[0] instanceof StoredProcedure));
        Assert.assertEquals((Object)"myStoredProcedure2", (Object)procs[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addStoredProcedures.cmd");
        candidates.add("myStoredProcedure1");
        candidates.add("myStoredProcedure2");
        this.assertTabCompletion("delete-stored-procedure myS", candidates);
        candidates.add("MyStoredProcedure3");
        this.assertTabCompletion("delete-stored-procedure ", candidates);
    }
}

