/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteTableCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable1", "add-table myTable2", "delete-table myTable1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Table[] tables = models[0].getTables(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)tables.length);
        Assert.assertEquals((Object)"myTable2", (Object)tables[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addTables.cmd");
        candidates.add("myTable1");
        candidates.add("myTable2");
        this.assertTabCompletion("delete-table myT", candidates);
        candidates.add("MyTable3");
        this.assertTabCompletion("delete-table ", candidates);
    }
}

