/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.VirtualProcedure;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteVirtualProcedureCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-virtual-procedure myVirtualProcedure1", "add-virtual-procedure myVirtualProcedure2", "delete-virtual-procedure myVirtualProcedure1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Procedure[] procs = models[0].getProcedures(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)procs.length);
        Assert.assertEquals((Object)true, (Object)(procs[0] instanceof VirtualProcedure));
        Assert.assertEquals((Object)"myVirtualProcedure2", (Object)procs[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addVirtualProcedures.cmd");
        candidates.add("myVirtualProcedure1");
        candidates.add("myVirtualProcedure2");
        this.assertTabCompletion("delete-virtual-procedure myV", candidates);
        candidates.add("MyVirtualProcedure3");
        this.assertTabCompletion("delete-virtual-procedure ", candidates);
    }
}

