/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.test.utils.TestUtilities;

public class ExportCommandTest
extends AbstractCommandTest {
    private static final String ALL_ELEMENTS_MODEL_TWO_DDL = "CREATE VIEW Test\nAS\nSELECT * FROM Test.getTest;";
    private static final String TWITTER_VIEW_MODEL_DDL = "CREATE VIRTUAL PROCEDURE getTweets(IN query varchar) RETURNS TABLE (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))\nAS\nSELECT tweet.* FROM (EXEC twitter.invokeHTTP(action => 'GET', endpoint => QUERYSTRING('', query AS q))) AS w, XMLTABLE('results' PASSING JSONTOXML('myxml', w.result) COLUMNS created_on string PATH 'created_at',  from_user string PATH 'from_user',  to_user string PATH 'to_user',  profile_image_url string PATH 'profile_image_url',  source string PATH 'source',  text string PATH 'text') AS tweet;\n\nCREATE VIEW Tweet\nAS\nSELECT * FROM twitterview.getTweets;";

    private KomodoObject addTweetVdbExample() throws KException, Exception {
        KomodoObject kWorkspace = _repo.komodoWorkspace(this.getTransaction());
        KomodoObject tweet = TestUtilities.createTweetExampleNode((Repository.UnitOfWork)this.getTransaction(), (KomodoObject)kWorkspace);
        Assert.assertNotNull((Object)tweet);
        return tweet;
    }

    private KomodoObject addAllElementsVdbExample() throws Exception {
        KomodoObject kWorkspace = _repo.komodoWorkspace(this.getTransaction());
        KomodoObject tweet = TestUtilities.createAllElementsExampleNode((Repository.UnitOfWork)this.getTransaction(), (KomodoObject)kWorkspace);
        Assert.assertNotNull((Object)tweet);
        return tweet;
    }

    @Test
    public void testExportCommandTweetViewModel() throws Exception {
        KomodoObject tweetVdb = this.addTweetVdbExample();
        File exportCmdFile = File.createTempFile("TestExportCommand", ".txt");
        exportCmdFile.deleteOnExit();
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        String[] commands = new String[]{"commit", "workspace", "cd " + tweetVdb.getName(this.getTransaction()), "cd twitterview", "export-ddl " + exportDest.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        String exportContents = TestUtilities.fileToString((File)exportDest);
        Assert.assertEquals((Object)"CREATE VIRTUAL PROCEDURE getTweets(IN query varchar) RETURNS TABLE (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))\nAS\nSELECT tweet.* FROM (EXEC twitter.invokeHTTP(action => 'GET', endpoint => QUERYSTRING('', query AS q))) AS w, XMLTABLE('results' PASSING JSONTOXML('myxml', w.result) COLUMNS created_on string PATH 'created_at',  from_user string PATH 'from_user',  to_user string PATH 'to_user',  profile_image_url string PATH 'profile_image_url',  source string PATH 'source',  text string PATH 'text') AS tweet;\n\nCREATE VIEW Tweet\nAS\nSELECT * FROM twitterview.getTweets;\n", (Object)exportContents);
    }

    @Test(expected=AssertionError.class)
    public void testExportCommandAllElementsVdbModelOne() throws Exception {
        KomodoObject allElementsVdb = this.addAllElementsVdbExample();
        File exportCmdFile = File.createTempFile("TestExportCommand", ".txt");
        exportCmdFile.deleteOnExit();
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        String[] commands = new String[]{"commit", "workspace", "cd " + allElementsVdb.getName(this.getTransaction()), "cd model-one", "export-ddl " + exportDest.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void testExportCommandAllElementsVdbModelTwo() throws Exception {
        KomodoObject allElementsVdb = this.addAllElementsVdbExample();
        File exportCmdFile = File.createTempFile("TestExportCommand", ".txt");
        exportCmdFile.deleteOnExit();
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        String[] commands = new String[]{"commit", "workspace", "cd " + allElementsVdb.getName(this.getTransaction()), "cd model-two", "export-ddl " + exportDest.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        String exportContents = TestUtilities.fileToString((File)exportDest);
        Assert.assertEquals((Object)"CREATE VIEW Test\nAS\nSELECT * FROM Test.getTest;\n", (Object)exportContents);
    }
}

