/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class SetModelPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testSetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "set-property description myDescription"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Assert.assertEquals((Object)"myDescription", (Object)models[0].getDescription(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addModels.cmd");
        String[] commands = new String[]{"cd myModel1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("modelType");
        candidates.add("metadataType");
        this.assertTabCompletion("set-property m", candidates);
        this.assertTabCompletion("set-property M", candidates);
    }

    @Test
    public void shouldSetModelTypeToPhyscalIgnoringTextCase() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "set-property modelType pHySiCal"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)models.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)models[0].getModelType(this.getTransaction()), (Matcher)Is.is((Object)Model.Type.PHYSICAL));
    }

    @Test
    public void shouldSetModelTypeToVirtualIgnoringTextCase() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "set-property modelType ViRtUaL"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)models.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)models[0].getModelType(this.getTransaction()), (Matcher)Is.is((Object)Model.Type.VIRTUAL));
    }
}

