/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowPushdownFunctionsCommandTest
extends AbstractCommandTest {
    private static final String FUNCTION_1 = "my_function";
    private static final String FUNCTION_2 = "your_function";
    private static final String FUNCTION_3 = "xyz";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-pushdown-function my_function", "add-pushdown-function your_function", "add-pushdown-function xyz"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-pushdown-functions my_function your_function xyz"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayPushdownFunctions() throws Exception {
        String[] commands = new String[]{"show-pushdown-functions"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayPushdownFunctionsThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-pushdown-functions *z*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-pushdown-functions *a*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(FUNCTION_3), (Matcher)Is.is((Object)false));
    }
}

