/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowSourcesCommandTest
extends AbstractCommandTest {
    private static final String SOURCE_1 = "my_source";
    private static final String SOURCE_2 = "your_source";
    private static final String SOURCE_3 = "so_urce";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-source my_source", "add-source your_source", "add-source so_urce"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-sources my_source *o_*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplaySources() throws Exception {
        String[] commands = new String[]{"show-sources"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplaySourcesThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-sources *y*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-sources *blah*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(SOURCE_3), (Matcher)Is.is((Object)false));
    }
}

