/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowStoredProceduresCommandTest
extends AbstractCommandTest {
    private static final String PROC_1 = "my_stored_procedure";
    private static final String PROC_2 = "your_stored_procedure";
    private static final String PROC_3 = "another_stored_procedure";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-stored-procedure my_stored_procedure", "add-stored-procedure your_stored_procedure", "add-stored-procedure another_stored_procedure"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-stored-procedures my_stored_procedure another*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayStoredProcedures() throws Exception {
        String[] commands = new String[]{"show-stored-procedures"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayStoredProceduresThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-stored-procedures *your*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-stored-procedures *blah*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)false));
    }
}

