/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowTablesCommandTest
extends AbstractCommandTest {
    private static final String TABLE_1 = "my_table";
    private static final String TABLE_2 = "your_table";
    private static final String TABLE_3 = "abcdef";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table my_table", "add-table your_table", "add-table abcdef"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-tables my* *def"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(TABLE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayTables() throws Exception {
        String[] commands = new String[]{"show-tables"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(TABLE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayTablesThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-tables *_table"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(TABLE_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-tables *blah*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(TABLE_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(TABLE_3), (Matcher)Is.is((Object)false));
    }
}

