/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowVirtualProceduresCommandTest
extends AbstractCommandTest {
    private static final String PROC_1 = "my_virtual_procedure";
    private static final String PROC_2 = "your_virtual_procedure";
    private static final String PROC_3 = "elvis";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-virtual-procedure my_virtual_procedure", "add-virtual-procedure your_virtual_procedure", "add-virtual-procedure elvis"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-virtual-procedures my_virtual_procedure *our*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldDisplayStoredProcedures() throws Exception {
        String[] commands = new String[]{"show-virtual-procedures"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayStoredProceduresThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-virtual-procedures elvis"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-virtual-procedures presley"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(PROC_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(PROC_3), (Matcher)Is.is((Object)false));
    }
}

