/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.modelsource;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetModelSourcePropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-source mySource", "cd mySource", "set-property sourceJndiName myJndi", "unset-property sourceJndiName"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        ModelSource[] sources = models[0].getSources(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)sources.length);
        Assert.assertEquals((Object)"mySource", (Object)sources[0].getName(this.getTransaction()));
        Assert.assertEquals(null, (Object)sources[0].getJndiName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addSources.cmd");
        String[] commands = new String[]{"cd mySource1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("sourceTranslator");
        this.assertTabCompletion("unset-property sourceT", candidates);
        this.assertTabCompletion("unset-property sourcet", candidates);
    }
}

