/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteMaskCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "add-mask myMask1", "add-mask myMask2", "delete-mask myMask1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)permissions.length);
        Assert.assertEquals((Object)"myPermission", (Object)permissions[0].getName(this.getTransaction()));
        Mask[] masks = permissions[0].getMasks(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)masks.length);
        Assert.assertEquals((Object)"myMask2", (Object)masks[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addMasks.cmd");
        candidates.add("myMask1");
        candidates.add("myMask2");
        this.assertTabCompletion("delete-mask myM", candidates);
        candidates.add("MyMask3");
        this.assertTabCompletion("delete-mask ", candidates);
    }
}

