/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class SetPermissionPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testSetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowAlter true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)permissions.length);
        Assert.assertEquals((Object)"myPermission", (Object)permissions[0].getName(this.getTransaction()));
        Assert.assertEquals((Object)true, (Object)permissions[0].isAllowAlter(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addPermissions.cmd");
        String[] commands = new String[]{"cd myPermission1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("allowCreate");
        this.assertTabCompletion("set-property allowCre", candidates);
        this.assertTabCompletion("set-property allowcre", candidates);
    }

    @Test
    public void shouldSetAllowCreate() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowCreate true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)dataRoles.length, (Matcher)Is.is((Object)1));
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)permissions[0].isAllowCreate(this.getTransaction()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetAllowDelete() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowDelete true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)dataRoles.length, (Matcher)Is.is((Object)1));
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)permissions[0].isAllowDelete(this.getTransaction()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetAllowExecute() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowExecute true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)dataRoles.length, (Matcher)Is.is((Object)1));
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)permissions[0].isAllowExecute(this.getTransaction()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetAllowLanguage() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowLanguage true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)dataRoles.length, (Matcher)Is.is((Object)1));
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)permissions[0].isAllowLanguage(this.getTransaction()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetAllowRead() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowRead true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)dataRoles.length, (Matcher)Is.is((Object)1));
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)permissions[0].isAllowRead(this.getTransaction()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSetAllowUpdate() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowUpdate true"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)dataRoles.length, (Matcher)Is.is((Object)1));
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)permissions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)permissions[0].isAllowUpdate(this.getTransaction()), (Matcher)Is.is((Object)true));
    }
}

