/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowConditionsCommandTest
extends AbstractCommandTest {
    private static final String CONDITION_1 = "my_condition";
    private static final String CONDITION_2 = "your_condition";
    private static final String CONDITION_3 = "mr_condition";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "add-condition my_condition", "add-condition your_condition", "add-condition mr_condition"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-conditions my_condition your_condition"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldDisplayConditions() throws Exception {
        String[] commands = new String[]{"show-conditions"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayConditionsThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-conditions m*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-conditions blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONDITION_3), (Matcher)Is.is((Object)false));
    }
}

