/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowMasksCommandTest
extends AbstractCommandTest {
    private static final String MASK_1 = "my_mask";
    private static final String MASK_2 = "your_mask";
    private static final String MASK_3 = "batman_mask";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "add-mask my_mask", "add-mask your_mask", "add-mask batman_mask"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-masks blah my_mask *foo* your_mask"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(MASK_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(MASK_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(MASK_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldDisplayMasks() throws Exception {
        String[] commands = new String[]{"show-masks"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(MASK_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(MASK_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(MASK_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayMasksThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-masks *our*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(MASK_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(MASK_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(MASK_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-masks *blah*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(MASK_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(MASK_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(MASK_3), (Matcher)Is.is((Object)false));
    }
}

