/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.permission;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetPermissionPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "cd myDataRole", "add-permission myPermission", "cd myPermission", "set-property allowAlter true", "unset-property allowAlter"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        Permission[] permissions = dataRoles[0].getPermissions(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)permissions.length);
        Assert.assertEquals((Object)"myPermission", (Object)permissions[0].getName(this.getTransaction()));
        Assert.assertEquals((Object)false, (Object)permissions[0].isAllowAlter(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addPermissions.cmd");
        String[] commands = new String[]{"cd myPermission1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("allowCreate");
        this.assertTabCompletion("unset-property allowCre", candidates);
        this.assertTabCompletion("unset-property allowcre", candidates);
    }
}

