/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.pushdownfunction;

import java.util.Collections;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class PushdownFunctionRenameCommandTest
extends AbstractCommandTest {
    @Test(expected=AssertionError.class)
    public void shouldNotAllowRenameOfParameterNameToResultSet() throws Exception {
        this.setup("commandFiles", "addPushdownFuncParams.cmd");
        String[] commands = new String[]{"rename myParameter1 resultSet"};
        this.execute(commands);
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowRenameSelfToResultSet() throws Exception {
        this.setup("commandFiles", "addPushdownFunctions.cmd");
        String[] commands = new String[]{"cd myPushdownFunction1", "rename resultSet"};
        this.execute(commands);
    }

    @Test
    public void shouldNotHaveResultSetCandidateInTabCompletion() throws Exception {
        this.setup("commandFiles", "addPushdownFunctions.cmd");
        String[] commands = new String[]{"cd myPushdownFunction1", "set-result-set DataTypeResultSet"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertTabCompletion("rename ", Collections.emptyList());
    }
}

