/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.pushdownfunction;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.ProcedureResultSet;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class SetResultSetCommandTest
extends AbstractCommandTest {
    @Test
    public void testSet() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-pushdown-function myPushdownFunction", "cd myPushdownFunction", "set-result-set DataTypeResultSet"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Function[] functions = models[0].getFunctions(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)functions.length);
        Assert.assertEquals((Object)true, (Object)(functions[0] instanceof PushdownFunction));
        Assert.assertEquals((Object)"myPushdownFunction", (Object)functions[0].getName(this.getTransaction()));
        ProcedureResultSet rSet = ((PushdownFunction)functions[0]).getResultSet(this.getTransaction());
        Assert.assertNotNull((Object)rSet);
    }
}

