/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.schema;

import java.io.File;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Schema;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.test.utils.TestUtilities;

public final class ExportCommandTest
extends AbstractCommandTest {
    private static final String TWITTER_VIEW_MODEL_DDL = "CREATE VIRTUAL PROCEDURE getTweets(IN query varchar) RETURNS TABLE (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))\nAS\nSELECT tweet.* FROM (EXEC twitter.invokeHTTP(action => 'GET', endpoint => QUERYSTRING('', query AS q))) AS w, XMLTABLE('results' PASSING JSONTOXML('myxml', w.result) COLUMNS created_on string PATH 'created_at',  from_user string PATH 'from_user',  to_user string PATH 'to_user',  profile_image_url string PATH 'profile_image_url',  source string PATH 'source',  text string PATH 'text') AS tweet;\n\nCREATE VIEW Tweet\nAS\nSELECT * FROM twitterview.getTweets;";

    private KomodoObject addSchemaExample() throws Exception {
        KomodoObject kWorkspace = _repo.komodoWorkspace(this.getTransaction());
        WorkspaceManager manager = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Schema schema = manager.createSchema(this.getTransaction(), kWorkspace, "TestTweetSchema");
        schema.setRendition(this.getTransaction(), TWITTER_VIEW_MODEL_DDL);
        Assert.assertNotNull((Object)schema);
        return schema;
    }

    @Test
    @Ignore(value="Currently disabled")
    public void testExportCommandSchemaRendition() throws Exception {
        this.addSchemaExample();
        File exportCmdFile = File.createTempFile("TestExportCommand", ".txt");
        exportCmdFile.deleteOnExit();
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        String[] commands = new String[]{"commit", "workspace", "cd TestTweetSchema", "export-ddl " + exportDest.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        String exportContents = TestUtilities.fileToString((File)exportDest);
        Assert.assertEquals((Object)"CREATE VIRTUAL PROCEDURE getTweets(IN query varchar) RETURNS TABLE (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140))\nAS\nSELECT tweet.* FROM (EXEC twitter.invokeHTTP(action => 'GET', endpoint => QUERYSTRING('', query AS q))) AS w, XMLTABLE('results' PASSING JSONTOXML('myxml', w.result) COLUMNS created_on string PATH 'created_at',  from_user string PATH 'from_user',  to_user string PATH 'to_user',  profile_image_url string PATH 'profile_image_url',  source string PATH 'source',  text string PATH 'text') AS tweet;\n\nCREATE VIEW Tweet\nAS\nSELECT * FROM twitterview.getTweets;\n", (Object)exportContents);
    }
}

