/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.schema;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Schema;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;

public final class UnsetSchemaPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-schema testSchema", "cd testSchema", "set-property rendition \"CREATE FOREIGN TABLE G1 (e1 integer) OPTIONS (ANNOTATION 'test', CARDINALITY '12');\"", "unset-property rendition"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Schema[] schemas = wkspMgr.findSchemas(this.getTransaction());
        Assert.assertEquals((long)1L, (long)schemas.length);
        Assert.assertEquals((Object)"testSchema", (Object)schemas[0].getName(this.getTransaction()));
        String rendition = schemas[0].getRendition(this.getTransaction());
        Assert.assertEquals((Object)true, (Object)StringUtils.isEmpty((String)rendition));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addSchemas.cmd");
        String[] commands = new String[]{"cd mySchema1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("rendition");
        this.assertTabCompletion("unset-property REN", candidates);
        this.assertTabCompletion("unset-property Ren", candidates);
    }
}

