/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.teiid.Teiid;
import org.komodo.spi.repository.Descriptor;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidInstance;
import org.komodo.spi.runtime.TeiidPropertyDefinition;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;
import org.mockito.Mockito;

public abstract class AbstractServerCommandTest
extends AbstractCommandTest {
    protected static final TeiidVdb VDB1 = (TeiidVdb)Mockito.mock(TeiidVdb.class);
    protected static final TeiidVdb VDB2 = (TeiidVdb)Mockito.mock(TeiidVdb.class);
    protected static final TeiidTranslator TRANSLATOR1 = (TeiidTranslator)Mockito.mock(TeiidTranslator.class);
    protected static final TeiidTranslator TRANSLATOR2 = (TeiidTranslator)Mockito.mock(TeiidTranslator.class);
    protected static final TeiidDataSource DS1 = (TeiidDataSource)Mockito.mock(TeiidDataSource.class);
    protected static final TeiidDataSource DS2 = (TeiidDataSource)Mockito.mock(TeiidDataSource.class);
    protected static final String DS_TYPE1 = "DS_TYPE1";
    protected static final String DS_TYPE2 = "DS_TYPE2";

    protected void initServer(String teiidName, boolean serverConnected, TeiidVdb[] vdbs, TeiidDataSource[] dataSources, TeiidTranslator[] translators, String[] dataSourceTypes) throws Exception {
        Teiid teiid = (Teiid)Mockito.mock(Teiid.class);
        Mockito.when((Object)teiid.getName(this.getTransaction())).thenReturn((Object)teiidName);
        Mockito.when((Object)teiid.getRepository()).thenReturn((Object)_repo);
        Descriptor descriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)descriptor.getName()).thenReturn((Object)"tko:teiid");
        Mockito.when((Object)teiid.getPrimaryType(this.getTransaction())).thenReturn((Object)descriptor);
        Mockito.when((Object)teiid.hasDescriptor(this.getTransaction(), "tko:teiid")).thenReturn((Object)true);
        _repo.add(this.getTransaction(), null, teiidName, "tko:teiid");
        TeiidInstance teiidInstance = (TeiidInstance)Mockito.mock(TeiidInstance.class);
        Mockito.when((Object)teiid.getTeiidInstance(this.getTransaction())).thenReturn((Object)teiidInstance);
        Mockito.when((Object)teiidInstance.isConnected()).thenReturn((Object)serverConnected);
        Mockito.when((Object)teiidInstance.hasVdb("myVdb")).thenReturn((Object)false);
        Mockito.when((Object)teiidInstance.hasVdb("VDB1")).thenReturn((Object)true);
        Mockito.when((Object)teiidInstance.hasVdb("VDB2")).thenReturn((Object)true);
        Mockito.when((Object)teiidInstance.dataSourceExists("myDs")).thenReturn((Object)false);
        Mockito.when((Object)teiidInstance.dataSourceExists("DS1")).thenReturn((Object)true);
        Mockito.when((Object)teiidInstance.dataSourceExists("DS2")).thenReturn((Object)true);
        TeiidPropertyDefinition propDefn1 = (TeiidPropertyDefinition)Mockito.mock(TeiidPropertyDefinition.class);
        Mockito.when((Object)propDefn1.getDisplayName()).thenReturn((Object)"Prop1");
        Mockito.when((Object)propDefn1.getDefaultValue()).thenReturn((Object)"Value1");
        TeiidPropertyDefinition propDefn2 = (TeiidPropertyDefinition)Mockito.mock(TeiidPropertyDefinition.class);
        Mockito.when((Object)propDefn2.getDisplayName()).thenReturn((Object)"Prop2");
        Mockito.when((Object)propDefn2.getDefaultValue()).thenReturn((Object)"Value2");
        Mockito.when((Object)teiidInstance.getTemplatePropertyDefns(DS_TYPE1)).thenReturn(Arrays.asList(propDefn1, propDefn2));
        Mockito.when((Object)teiidInstance.getTemplatePropertyDefns(DS_TYPE2)).thenReturn(Arrays.asList(propDefn1, propDefn2));
        if (vdbs != null) {
            Mockito.when((Object)teiidInstance.getVdbs()).thenReturn(Arrays.asList(vdbs));
        }
        if (vdbs != null) {
            Mockito.when((Object)teiidInstance.getVdb(VDB1.getName())).thenReturn((Object)VDB1);
        }
        if (vdbs != null) {
            Mockito.when((Object)teiidInstance.getVdb(VDB2.getName())).thenReturn((Object)VDB2);
        }
        if (dataSources != null) {
            Mockito.when((Object)teiidInstance.getDataSources()).thenReturn(Arrays.asList(dataSources));
        }
        if (dataSources != null) {
            Mockito.when((Object)teiidInstance.getDataSource(DS1.getName())).thenReturn((Object)DS1);
        }
        if (dataSources != null) {
            Mockito.when((Object)teiidInstance.getDataSource(DS2.getName())).thenReturn((Object)DS2);
        }
        if (dataSourceTypes != null) {
            Mockito.when((Object)teiidInstance.getDataSourceTypeNames()).thenReturn(new HashSet<String>(Arrays.asList(dataSourceTypes)));
        }
        if (translators != null) {
            Mockito.when((Object)teiidInstance.getTranslators()).thenReturn(Arrays.asList(translators));
        }
        if (translators != null) {
            Mockito.when((Object)teiidInstance.getTranslator(TRANSLATOR1.getName())).thenReturn((Object)TRANSLATOR1);
        }
        if (translators != null) {
            Mockito.when((Object)teiidInstance.getTranslator(TRANSLATOR2.getName())).thenReturn((Object)TRANSLATOR2);
        }
        this.wsStatus.updateAvailableCommands();
    }

    static {
        Mockito.when((Object)VDB1.getName()).thenReturn((Object)"VDB1");
        Mockito.when((Object)VDB2.getName()).thenReturn((Object)"VDB2");
        Mockito.when((Object)VDB1.getVersion()).thenReturn((Object)"1");
        Mockito.when((Object)VDB2.getVersion()).thenReturn((Object)"2");
        Mockito.when((Object)VDB1.isActive()).thenReturn((Object)true);
        Mockito.when((Object)VDB2.isActive()).thenReturn((Object)false);
        Mockito.when((Object)VDB1.getModelNames()).thenReturn(Arrays.asList("Model1", "Model2"));
        Mockito.when((Object)VDB2.getModelNames()).thenReturn(Arrays.asList("Model1", "Model2"));
        Mockito.when((Object)VDB1.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)VDB2.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)TRANSLATOR1.getName()).thenReturn((Object)"TRANSLATOR1");
        Mockito.when((Object)TRANSLATOR2.getName()).thenReturn((Object)"TRANSLATOR2");
        Mockito.when((Object)TRANSLATOR1.getType()).thenReturn((Object)"oracle");
        Mockito.when((Object)TRANSLATOR2.getType()).thenReturn((Object)"salesforce");
        Mockito.when((Object)TRANSLATOR1.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)TRANSLATOR2.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)DS1.getName()).thenReturn((Object)"DS1");
        Mockito.when((Object)DS2.getName()).thenReturn((Object)"DS2");
        Mockito.when((Object)DS1.getDisplayName()).thenReturn((Object)"DS1");
        Mockito.when((Object)DS2.getDisplayName()).thenReturn((Object)"DS2");
        Mockito.when((Object)DS1.getType()).thenReturn((Object)"oracle");
        Mockito.when((Object)DS2.getType()).thenReturn((Object)"file");
        Mockito.when((Object)DS1.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)DS2.getProperties()).thenReturn((Object)new Properties());
    }
}

