/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.komodo.relational.commands.server.AbstractServerCommandTest;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.ShellCommand;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;

public final class ServerDeployDatasourceCommandTest
extends AbstractServerCommandTest {
    @Test
    @Ignore
    public void shouldNotBeAvailableForServerNotConnected() throws Exception {
        this.initServer("myTeiid", false, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        this.assertCommandsNotAvailable(new String[]{"server-deploy-datasource"});
    }

    @Test
    @Ignore
    public void shouldNotDeployMissingWorkspaceDatasource() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-datasource DS1", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-datasource");
        command.setArguments(new Arguments("myDs"));
        result = command.execute();
        Assert.assertThat((Object)result.isOk(), (Matcher)Is.is((Object)false));
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("myDs"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("not found"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldNotDeployDatasourceExistsOnServer() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-datasource DS1", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-datasource");
        command.setArguments(new Arguments("DS1"));
        result = command.execute();
        Assert.assertThat((Object)result.isOk(), (Matcher)Is.is((Object)false));
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("DS1"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("already exists"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldDeployDatasource() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-datasource myDs", "cd myDs", "set-property driverName DS_TYPE1", "workspace", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        result = this.execute(new String[]{"server-deploy-datasource myDs"});
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains("deployed successfully"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldDeployExistingDatasourceWithOverwrite() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-datasource DS1", "cd DS1", "set-property driverName DS_TYPE1", "workspace", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-datasource");
        command.setArguments(new Arguments("DS1 -o"));
        result = command.execute();
        this.assertCommandResultOk(result);
    }
}

