/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.komodo.relational.commands.server.AbstractServerCommandTest;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.ShellCommand;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;

public final class ServerDeployVdbCommandTest
extends AbstractServerCommandTest {
    @Test
    @Ignore
    public void shouldNotBeAvailableForServerNotConnected() throws Exception {
        this.initServer("myTeiid", false, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        this.assertCommandsNotAvailable(new String[]{"server-deploy-vdb"});
    }

    @Test
    @Ignore
    public void shouldNotDeployMissingWorkspaceVDB() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-vdb VDB1", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-vdb");
        command.setArguments(new Arguments("myVdb"));
        result = command.execute();
        Assert.assertThat((Object)result.isOk(), (Matcher)Is.is((Object)false));
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("myVdb"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("not found"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldNotDeployVDBExistsOnServer() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-vdb VDB1", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-vdb");
        command.setArguments(new Arguments("VDB1"));
        result = command.execute();
        Assert.assertThat((Object)result.isOk(), (Matcher)Is.is((Object)false));
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("VDB1"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("already exists"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldDeployVdb() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-vdb myVdb", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        result = this.execute(new String[]{"server-deploy-vdb myVdb"});
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains("deployed successfully"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldDeployExistingVDBWithOverwrite() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-vdb VDB1", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-vdb");
        command.setArguments(new Arguments("VDB1 -o"));
        result = command.execute();
        this.assertCommandResultOk(result);
    }

    @Test
    @Ignore
    public void shouldNotDeployVDBServerMissingSources() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "create-vdb VDB1", "cd VDB1", "add-model myModel", "cd myModel", "add-source modelSource", "cd modelSource", "set-property sourceJndiName java:/modelSource", "commit", "set-server myTeiid", "workspace"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        ShellCommand command = this.wsStatus.getCommand("server-deploy-vdb");
        command.setArguments(new Arguments("VDB1 -o"));
        result = command.execute();
        Assert.assertThat((Object)result.isOk(), (Matcher)Is.is((Object)false));
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("server does not have source"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("java:/modelSource"), (Matcher)Is.is((Object)true));
    }
}

