/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.komodo.relational.commands.server.AbstractServerCommandTest;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.ShellCommand;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;

public final class ServerDisconnectCommandTest
extends AbstractServerCommandTest {
    @Test
    @Ignore
    public void shouldNotBeAvailableForServerNotConnected() throws Exception {
        this.initServer("myTeiid", false, new TeiidVdb[]{VDB1}, new TeiidDataSource[]{DS1}, new TeiidTranslator[]{TRANSLATOR1}, new String[]{"DS_TYPE1"});
        this.assertCommandsNotAvailable(new String[]{"server-disconnect"});
    }

    @Test
    @Ignore
    public void shouldFailNoServerConnected() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", false, null, null, null, null);
        ShellCommand command = this.wsStatus.getCommand("server-disconnect");
        result = command.execute();
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("server-disconnect"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("not found"), (Matcher)Is.is((Object)true));
    }

    @Test
    @Ignore
    public void shouldDisconnectServer() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-teiid myTeiid", "commit", "set-server myTeiid"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.initServer("myTeiid", true, null, null, null, null);
        ShellCommand command = this.wsStatus.getCommand("server-disconnect");
        result = command.execute();
        this.assertCommandResultOk(result);
        String output = result.getMessage();
        Assert.assertThat((String)output, (Object)output.contains("myTeiid"), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains("disconnected"), (Matcher)Is.is((Object)true));
    }
}

