/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.server.AbstractServerCommandTest;
import org.komodo.shell.api.CommandResult;

public class ServerShowPropertiesCommandTest
extends AbstractServerCommandTest {
    @Test(expected=AssertionError.class)
    public void shouldFailTooManyArgs() throws Exception {
        String[] commands = new String[]{"show-server-properties extraArg"};
        this.execute(commands);
    }

    @Test
    public void shouldBeAvailableAtLibrary() throws Exception {
        String[] commands = new String[]{"library"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertCommandsAvailable(new String[]{"server-show-properties"});
    }

    @Test
    public void shouldBeAvailableAtRoot() throws Exception {
        this.assertCommandsAvailable(new String[]{"server-show-properties"});
    }

    @Test
    public void shouldBeAvailableAtWorkspace() throws Exception {
        String[] commands = new String[]{"workspace"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertCommandsAvailable(new String[]{"server-show-properties"});
    }

    @Test
    public void shouldShowProperties() throws Exception {
        String[] commands = new String[]{"server-show-properties"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String writerOutput = this.getCommandOutput();
        Assert.assertTrue((boolean)writerOutput.contains("adminUser"));
        Assert.assertTrue((boolean)writerOutput.contains("jdbcPort"));
    }
}

