/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.server;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.server.AbstractServerCommandTest;
import org.komodo.relational.teiid.Teiid;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.runtime.TeiidAdminInfo;
import org.komodo.spi.runtime.version.TeiidVersion;
import org.komodo.spi.runtime.version.TeiidVersionProvider;

public final class ServerUnsetPropertyCommandTest
extends AbstractServerCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"server-set-property adminPort 8765", "server-unset-property adminPort", "server-show-properties"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        List results = _repo.searchByType(this.sysTx(), new String[]{"tko:teiid"});
        KomodoObject serverObj = (KomodoObject)results.get(0);
        if (Teiid.RESOLVER.resolvable(this.getTransaction(), serverObj)) {
            Teiid server = (Teiid)Teiid.RESOLVER.resolve(this.getTransaction(), serverObj);
            TeiidVersion version = TeiidVersionProvider.getInstance().getTeiidVersion();
            Assert.assertTrue((server.getAdminPort(this.getTransaction()) == TeiidAdminInfo.Util.defaultPort((TeiidVersion)version) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("adminPort");
        candidates.add("adminPswd");
        this.assertTabCompletion("server-unset-property ADMINP", candidates);
        this.assertTabCompletion("server-unset-property adminP", candidates);
    }
}

