/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.storedprocedure;

import java.util.Collections;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class StoredProcedureRenameCommandTest
extends AbstractCommandTest {
    @Test(expected=AssertionError.class)
    public void shouldNotAllowRenameOfParameterNameToResultSet() throws Exception {
        this.setup("commandFiles", "addStoredProcParams.cmd");
        String[] commands = new String[]{"rename myParameter1 resultSet"};
        this.execute(commands);
    }

    @Test(expected=AssertionError.class)
    public void shouldNotAllowRenameSelfToResultSet() throws Exception {
        this.setup("commandFiles", "addStoredProcedures.cmd");
        String[] commands = new String[]{"cd myStoredProcedure1", "rename resultSet"};
        this.execute(commands);
    }

    @Test
    public void shouldNotHaveResultSetCandidateInTabCompletion() throws Exception {
        this.setup("commandFiles", "addStoredProcedures.cmd");
        String[] commands = new String[]{"cd myStoredProcedure1", "set-result-set DataTypeResultSet"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertTabCompletion("rename ", Collections.emptyList());
    }
}

