/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class AddColumnCommandTest
extends AbstractCommandTest {
    @Test
    public void testAdd1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-column myColumn"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Table[] tables = models[0].getTables(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)tables.length);
        Assert.assertEquals((Object)"myTable", (Object)tables[0].getName(this.getTransaction()));
        Column[] columns = tables[0].getColumns(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)"myColumn", (Object)columns[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateColumnWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-column myColumn";
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-column myColumn", "add-column myColumn"};
        this.execute(commands);
    }
}

