/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.model.UniqueConstraint;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteUniqueConstraintCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-unique-constraint myUniqueConstraint1", "add-unique-constraint myUniqueConstraint2", "delete-unique-constraint myUniqueConstraint1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Table[] tables = models[0].getTables(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)tables.length);
        Assert.assertEquals((Object)"myTable", (Object)tables[0].getName(this.getTransaction()));
        UniqueConstraint[] ucs = tables[0].getUniqueConstraints(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)ucs.length);
        Assert.assertEquals((Object)"myUniqueConstraint2", (Object)ucs[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myUniqueConstraint1");
        candidates.add("myUniqueConstraint2");
        this.setup("commandFiles", "addUniqueConstraints.cmd");
        this.assertTabCompletion("delete-unique-constraint myU", candidates);
        candidates.add("MyUniqueConstraint3");
        this.assertTabCompletion("delete-unique-constraint ", candidates);
    }
}

