/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowColumnsCommandTest
extends AbstractCommandTest {
    private static final String COLUMN_1 = "my_column";
    private static final String COLUMN_2 = "your_column";
    private static final String COLUMN_3 = "column_three";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-column my_column", "add-column your_column", "add-column column_three"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-columns column_three *column*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayColumns() throws Exception {
        String[] commands = new String[]{"show-columns"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayColumnsThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-columns *column"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-columns *blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(COLUMN_3), (Matcher)Is.is((Object)false));
    }
}

