/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.table;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class ShowUniqueConstraintsCommandTest
extends AbstractCommandTest {
    private static final String CONSTRAINT_1 = "my_constraint";
    private static final String CONSTRAINT_2 = "your_constraint";
    private static final String CONSTRAINT_3 = "gabbie_girl";

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-table myTable", "cd myTable", "add-unique-constraint my_constraint", "add-unique-constraint your_constraint", "add-unique-constraint gabbie_girl"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldAllowMultiplePatterns() throws Exception {
        String[] commands = new String[]{"show-unique-constraints *girl *our* blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayUniqueConstraints() throws Exception {
        String[] commands = new String[]{"show-unique-constraints"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_1), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_2), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisplayUniqueConstraintsThatMatchPattern() throws Exception {
        String[] commands = new String[]{"show-unique-constraints *bb*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_3), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotMatchPattern() throws Exception {
        String[] commands = new String[]{"show-unique-constraints *blah*"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        String output = this.getCommandOutput();
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_1), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_2), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)output, (Object)output.contains(CONSTRAINT_3), (Matcher)Is.is((Object)false));
    }
}

