/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.tabularresultset;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.tabularresultset.TabularResultSetCommandTest;
import org.komodo.relational.model.ResultSetColumn;
import org.komodo.shell.api.CommandResult;

public final class AddColumnCommandTest
extends TabularResultSetCommandTest {
    @Test
    public void shouldAddColumn() throws Exception {
        String addedColumn = "myColumn";
        String[] commands = new String[]{"add-column myColumn"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        ResultSetColumn[] cols = this.get().getColumns(this.getTransaction());
        Assert.assertThat((Object)cols.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)cols[0].getName(this.getTransaction()), (Matcher)Is.is((Object)"myColumn"));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateColumnWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-column blah";
        String[] commands = new String[]{"add-column blah", "add-column blah"};
        this.execute(commands);
    }
}

