/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.tabularresultset;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.ProcedureResultSet;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.relational.model.TabularResultSet;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public abstract class TabularResultSetCommandTest
extends AbstractCommandTest {
    private TabularResultSet resultSet;

    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"workspace", "create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel ", "cd myModel", "add-pushdown-function myPushdownFunction", "cd myPushdownFunction", "set-result-set TabularResultSet", "cd resultSet"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs.length, (Matcher)Is.is((Object)1));
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)models.length, (Matcher)Is.is((Object)1));
        Function[] functions = models[0].getFunctions(this.getTransaction(), new String[0]);
        Assert.assertThat((Object)functions.length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)functions[0], (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(PushdownFunction.class)));
        ProcedureResultSet procedureResultSet = ((PushdownFunction)functions[0]).getResultSet(this.getTransaction());
        Assert.assertThat((Object)procedureResultSet, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(TabularResultSet.class)));
        this.resultSet = (TabularResultSet)procedureResultSet;
    }

    protected TabularResultSet get() {
        return this.resultSet;
    }
}

