/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.translator;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;

public final class TranslatorRenameCommandTest
extends AbstractCommandTest {
    @Test(expected=AssertionError.class)
    public void shouldFailWhenTooManyArgs() throws Exception {
        this.setup("commandFiles", "addTranslators.cmd");
        String[] commands = new String[]{"cd myTranslator1", "rename foo bar"};
        this.execute(commands);
    }

    @Test
    public void shouldNotHaveTabCompletion() throws Exception {
        this.setup("commandFiles", "addTranslators.cmd");
        String[] commands = new String[]{"cd myTranslator1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        this.assertTabCompletion("rename ", Collections.emptyList());
    }

    @Test
    public void shouldRenameSelf() throws Exception {
        this.setup("commandFiles", "addTranslators.cmd");
        String newName = "blah";
        String[] commands = new String[]{"cd myTranslator1", "rename blah"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertThat((Object)this.wsStatus.getCurrentContext().getName(this.getTransaction()), (Matcher)Is.is((Object)"blah"));
    }
}

