/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.translator;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetTranslatorPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-translator myTranslator tType", "cd myTranslator", "set-property description myDescription", "unset-property description"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Translator[] translators = vdbs[0].getTranslators(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)translators.length);
        Assert.assertEquals((Object)"myTranslator", (Object)translators[0].getName(this.getTransaction()));
        Assert.assertEquals(null, (Object)translators[0].getDescription(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addTranslators.cmd");
        String[] commands = new String[]{"cd myTranslator1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("description");
        this.assertTabCompletion("unset-property desc", candidates);
        this.assertTabCompletion("unset-property Desc", candidates);
    }
}

