/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class AddDataRoleCommandTest
extends AbstractCommandTest {
    @Test
    public void testAdd1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        DataRole[] dataRoles = vdbs[0].getDataRoles(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)dataRoles.length);
        Assert.assertEquals((Object)"myDataRole", (Object)dataRoles[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateDataRoleWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-data-role myDataRole";
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-data-role myDataRole", "add-data-role myDataRole"};
        this.execute(commands);
    }
}

