/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class AddTranslatorCommandTest
extends AbstractCommandTest {
    @Test
    public void testAdd1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-translator myTranslator tType"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Translator[] translators = vdbs[0].getTranslators(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)translators.length);
        Assert.assertEquals((Object)"myTranslator", (Object)translators[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotCreateTranslatorWithNameThatAlreadyExists() throws Exception {
        String cmd = "add-translator myTranslator tType";
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-translator myTranslator tType", "add-translator myTranslator tType"};
        this.execute(commands);
    }
}

